/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blocks.customs;

import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.tterrag.registrate.util.entry.ItemEntry;
import fr.iglee42.createcasing.items.CustomVerticalGearboxItem;
import fr.iglee42.createcasing.registries.EncasedBlockEntities;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;

public class CustomGearboxBlock
extends RotatedPillarKineticBlock
implements IBE<GearboxBlockEntity> {
    private final ItemEntry<CustomVerticalGearboxItem> verticalItem;

    public CustomGearboxBlock(BlockBehaviour.Properties properties, ItemEntry<CustomVerticalGearboxItem> verticalItem) {
        super(properties);
        this.verticalItem = verticalItem;
    }

    public BlockEntityType<? extends GearboxBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EncasedBlockEntities.GEARBOX.get();
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (((Direction.Axis)state.getValue((Property)AXIS)).isVertical()) {
            return super.getDrops(state, builder);
        }
        return Arrays.asList(new ItemStack((ItemLike)this.verticalItem.get()));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        if (((Direction.Axis)state.getValue((Property)AXIS)).isVertical()) {
            return super.getCloneItemStack(state, target, world, pos, player);
        }
        return new ItemStack((ItemLike)this.verticalItem.get());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)Direction.Axis.Y);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() != state.getValue((Property)AXIS);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    public Class<GearboxBlockEntity> getBlockEntityClass() {
        return GearboxBlockEntity.class;
    }
}

